﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using usbLan;
using System.IO;
using System.IO.Ports;
using System.Net.Sockets;
using System.Net;
using System.Net.NetworkInformation;

namespace TestDll.controlInterface
{
    public partial class phaseShifterForm : Form
    {
        SerialPort usbPort = null;
        Socket tcpConnect = null;
        string[] e2Strings = { "E1", "E2", "E3", "E4", "E5"};
        public phaseShifterForm()
        {
            InitializeComponent();
            rbUSB.Checked = true;
            gbUSBport.Enabled = true;
            gbLANport.Enabled = false;
            btRefreshCOMx_Click(null, null);
            btRefreshLocalIP_Click(null, null);
        }
        private void comboBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
        }
        private void btRefreshCOMx_Click(object sender, EventArgs e)
        {
            cbbCOMx.Items.Clear();
            string[] comPorts = commonModule.getCOMnames();
            for (int i = 0; i < comPorts.Length; i++)
            {
                cbbCOMx.Items.Add(comPorts[i]);
            }
            cbbCOMx.Text = comPorts[0];
        }
        private void btRefreshLocalIP_Click(object sender, EventArgs e)
        {
            cbbLocalIP.Items.Clear();
            string[] localIPs = commonModule.getLocalIPs();
            for (int i = 0; i < localIPs.Length; i++)
            {
                cbbLocalIP.Items.Add(localIPs[i]);
            }
            cbbLocalIP.Text = localIPs[0];
        }
        private void rbUSB_Click(object sender, EventArgs e)
        {
            rbUSB.Checked = true;
            gbUSBport.Enabled = true;
            gbLANport.Enabled = false;
        }
        private void rbLan_Click(object sender, EventArgs e)
        {
            rbLan.Checked = true;
            gbUSBport.Enabled = false;
            gbLANport.Enabled = true;
        }
        private void btConnectDevice_Click(object sender, EventArgs e)
        {
            if (rbUSB.Checked)
            {
                if (btConnect.Text == "Connect Device")
                {
                    try
                    {
                        usbPort = usbLan.commonModule.openConnectUSB(cbbCOMx.Text, Convert.ToInt32(cbbBaud.Text));
                        tbDeviceInfos.Text = usbLan.commonModule.getProductInformationUSB(usbPort);
                        btConnect.Text = "Close Connect";
                        btConnect.ForeColor = Color.Red;
                        btConnect.BackColor = Color.LimeGreen;
                    }
                    catch
                    {
                        tbDeviceInfos.Text = "";
                        usbLan.commonModule.closeConnectUSB(usbPort);
                        MessageBox.Show("Connect failure!");
                    }
                }
                else
                {
                    try
                    {
                        usbLan.commonModule.closeConnectUSB(usbPort);
                        btConnect.Text = "Connect Device";
                        btConnect.ForeColor = Color.Blue;
                        btConnect.BackColor = Color.Transparent;
                        tbDeviceInfos.Text = "";
                    }
                    catch
                    {
                        MessageBox.Show("Close failure!");
                    }
                }
            }
            else
            {
                if (btConnect.Text == "Connect Device")
                {
                    try
                    {
                        tcpConnect = usbLan.commonModule.openConnectTCP(cbbLocalIP.Text, tbDeviceIP.Text, Convert.ToInt32(nudDevicePort.Value));
                        tbDeviceInfos.Text = usbLan.commonModule.getProductInformationTCP(tcpConnect);
                        btConnect.Text = "Close Connect";
                        btConnect.ForeColor = Color.Red;
                        btConnect.BackColor = Color.LimeGreen;
                    }
                    catch
                    {
                        tbDeviceInfos.Text = "";
                        usbLan.commonModule.closeConnectTCP(tcpConnect);
                        MessageBox.Show("Connect failure!");
                    }
                }
                else
                {
                    try
                    {
                        usbLan.commonModule.closeConnectTCP(tcpConnect);
                        btConnect.Text = "Connect Device";
                        btConnect.ForeColor = Color.Blue;
                        btConnect.BackColor = Color.Transparent;
                        tbDeviceInfos.Text = "";
                    }
                    catch
                    {
                        MessageBox.Show("Close failure!");
                    }
                }
            }
        }

        private void btGetStepsize_Click(object sender, EventArgs e)
        {
            string hintsStr = "";
            cbbAttValue.Items.Clear();
            try
            {
                if(rbUSB.Checked)
                {
                    tbStepsize.Text = usbLan.PhaseShifterModule.getStepsizeUSB(usbPort);
                }
                else
                {
                    tbStepsize.Text = usbLan.PhaseShifterModule.getStepsizeTCP(tcpConnect);
                }
                hintsStr = checkReceiveString(tbStepsize.Text,"Get stepsize successful!");
                MessageBox.Show(hintsStr);
                for(int i=0;i< Math.Pow(2,Convert.ToDouble(nudControlBits.Value));i++)
                {
                    cbbAttValue.Items.Add((i * Convert.ToDouble(tbStepsize.Text)).ToString());
                }
                cbbAttValue.SelectedIndex = 0;
            }
            catch
            {
                MessageBox.Show("Get stepsize failure!");
            }
        }
        private void btSetPhaseValue_Click(object sender, System.EventArgs e)
        {
            string hintsStr = "";
            try
            {
                if(rbUSB.Checked)
                {
                    tbRecStr.Text = usbLan.PhaseShifterModule.setPhaseValueStepUSB(usbPort, cbbAttValue.SelectedIndex);
                }
                else
                {
                    tbRecStr.Text = usbLan.PhaseShifterModule.setPhaseValueStepTCP(tcpConnect,cbbAttValue.SelectedIndex);
                }
                hintsStr = checkReceiveString(tbRecStr.Text, "Set phase value successful!");
                MessageBox.Show(hintsStr);
            }
            catch
            {
                MessageBox.Show("Set phase value failure!");
            }
        }

        private void btQuery_Click(object sender, System.EventArgs e)
        {
            string hintsStr = "";
            try
            {
                if(rbUSB.Checked)
                {
                    tbQuery.Text = usbLan.PhaseShifterModule.getCurrentSettingsUSB(usbPort);
                }
                else
                {
                    tbQuery.Text = usbLan.PhaseShifterModule.getCurrentSettingsTCP(tcpConnect);
                }
                hintsStr = checkReceiveString(tbQuery.Text,"Get settings successful!");
                MessageBox.Show(hintsStr);
            }
            catch
            {
                MessageBox.Show("Get settings failure!");
            }
        }
        private string checkReceiveString(string recStr,string rightHints)
        {
            string hintsStr = "";
            if (Array.IndexOf(e2Strings,recStr)>=0)
            {
                hintsStr = usbLan.commonModule.queryErrorDescription(recStr);
            }
            else
            {
                hintsStr = rightHints;
            }
            return hintsStr;
        }
    }
}
